options(width = 120)
#********************************************************************************#
#*                                                                               #
#*  Purpose: R program to create a permanent R.RDS data set with the             #
#*           July 2018 Tobacco Use Self-Response weights. The program            #
#*           reads the file jul18srrep.dat and creates the file                  #
#*           REPS_W_CPSJUL18.RDSCPSJUL18.RDS                                     #
#*                                                                               #
#*  Notes:   The program uses the package readr                                  #
#                                                                                #
#********************************************************************************#

##################################################################################
# Set working directories
##################################################################################

setwd("//westat.com/DFS/NCIDCCPS/DCCPS - Global/Scientific Projects/TUS-CPS/Statistician/ifc/R work/prg")
getwd()

##################################################################################
# Load libraries
#
library(readr)


##################################################################################
## Create data dictionary with varaible names, witdths, type and labels
##################################################################################

data_diccionary <-
'QSTNUM      1       5     numeric      "Unique household identifier"
OCCURNUM     6       7     numeric      "Unique person identifier"
RepWgt0      8      17     numeric      "Self Resp Sample Weight"
RepWgt1      18     27     numeric      "Self Resp Replicate Weight #1"
RepWgt2      28     37     numeric      "Self Resp Replicate Weight #2"
RepWgt3      38     47     numeric      "Self Resp Replicate Weight #3"
RepWgt4      48     57     numeric      "Self Resp Replicate Weight #4"
RepWgt5      58     67     numeric      "Self Resp Replicate Weight #5"
RepWgt6      68     77     numeric      "Self Resp Replicate Weight #6"
RepWgt7      78     87     numeric      "Self Resp Replicate Weight #7"
RepWgt8      88     97     numeric      "Self Resp Replicate Weight #8"
RepWgt9      98     107    numeric      "Self Resp Replicate Weight #9"
RepWgt10    108     117    numeric      "Self Resp Replicate Weight #10"
RepWgt11    118     127    numeric      "Self Resp Replicate Weight #11"
RepWgt12    128     137    numeric      "Self Resp Replicate Weight #12"
RepWgt13    138     147    numeric      "Self Resp Replicate Weight #13"
RepWgt14    148     157    numeric      "Self Resp Replicate Weight #14"
RepWgt15    158     167    numeric      "Self Resp Replicate Weight #15"
RepWgt16    168     177    numeric      "Self Resp Replicate Weight #16"
RepWgt17    178     187    numeric      "Self Resp Replicate Weight #17"
RepWgt18    188     197    numeric      "Self Resp Replicate Weight #18"
RepWgt19    198     207    numeric      "Self Resp Replicate Weight #19"
RepWgt20    208     217    numeric      "Self Resp Replicate Weight #20"
RepWgt21    218     227    numeric      "Self Resp Replicate Weight #21"
RepWgt22    228     237    numeric      "Self Resp Replicate Weight #22"
RepWgt23    238     247    numeric      "Self Resp Replicate Weight #23"
RepWgt24    248     257    numeric      "Self Resp Replicate Weight #24"
RepWgt25    258     267    numeric      "Self Resp Replicate Weight #25"
RepWgt26    268     277    numeric      "Self Resp Replicate Weight #26"
RepWgt27    278     287    numeric      "Self Resp Replicate Weight #27"
RepWgt28    288     297    numeric      "Self Resp Replicate Weight #28"
RepWgt29    298     307    numeric      "Self Resp Replicate Weight #29"
RepWgt30    308     317    numeric      "Self Resp Replicate Weight #30"
RepWgt31    318     327    numeric      "Self Resp Replicate Weight #31"
RepWgt32    328     337    numeric      "Self Resp Replicate Weight #32"
RepWgt33    338     347    numeric      "Self Resp Replicate Weight #33"
RepWgt34    348     357    numeric      "Self Resp Replicate Weight #34"
RepWgt35    358     367    numeric      "Self Resp Replicate Weight #35"
RepWgt36    368     377    numeric      "Self Resp Replicate Weight #36"
RepWgt37    378     387    numeric      "Self Resp Replicate Weight #37"
RepWgt38    388     397    numeric      "Self Resp Replicate Weight #38"
RepWgt39    399     407    numeric      "Self Resp Replicate Weight #39"
RepWgt40    408     417    numeric      "Self Resp Replicate Weight #40"
RepWgt41    418     427    numeric      "Self Resp Replicate Weight #41"
RepWgt42    428     437    numeric      "Self Resp Replicate Weight #42"
RepWgt43    438     447    numeric      "Self Resp Replicate Weight #43"
RepWgt44    448     457    numeric      "Self Resp Replicate Weight #44"
RepWgt45    458     467    numeric      "Self Resp Replicate Weight #45"
RepWgt46    468     477    numeric      "Self Resp Replicate Weight #46"
RepWgt47    478     487    numeric      "Self Resp Replicate Weight #47"
RepWgt48    488     497    numeric      "Self Resp Replicate Weight #48"
RepWgt49    498     507    numeric      "Self Resp Replicate Weight #49"
RepWgt50    508     517    numeric      "Self Resp Replicate Weight #50"
RepWgt51    518     527    numeric      "Self Resp Replicate Weight #51"
RepWgt52    528     537    numeric      "Self Resp Replicate Weight #52"
RepWgt53    538     547    numeric      "Self Resp Replicate Weight #53"
RepWgt54    548     557    numeric      "Self Resp Replicate Weight #54"
RepWgt55    558     567    numeric      "Self Resp Replicate Weight #55"
RepWgt56    568     577    numeric      "Self Resp Replicate Weight #56"
RepWgt57    578     587    numeric      "Self Resp Replicate Weight #57"
RepWgt58    588     597    numeric      "Self Resp Replicate Weight #58"
RepWgt59    598     607    numeric      "Self Resp Replicate Weight #59"
RepWgt60    608     617    numeric      "Self Resp Replicate Weight #60"
RepWgt61    618     627    numeric      "Self Resp Replicate Weight #61"
RepWgt62    628     637    numeric      "Self Resp Replicate Weight #62"
RepWgt63    638     647    numeric      "Self Resp Replicate Weight #63"
RepWgt64    648     657    numeric      "Self Resp Replicate Weight #64"
RepWgt65    658     667    numeric      "Self Resp Replicate Weight #65"
RepWgt66    668     677    numeric      "Self Resp Replicate Weight #66"
RepWgt67    678     687    numeric      "Self Resp Replicate Weight #67"
RepWgt68    688     697    numeric      "Self Resp Replicate Weight #68"
RepWgt69    699     707    numeric      "Self Resp Replicate Weight #69"
RepWgt70    708     717    numeric      "Self Resp Replicate Weight #70"
RepWgt71    718     727    numeric      "Self Resp Replicate Weight #71"
RepWgt72    728     737    numeric      "Self Resp Replicate Weight #72"
RepWgt73    738     747    numeric      "Self Resp Replicate Weight #73"
RepWgt74    748     757    numeric      "Self Resp Replicate Weight #74"
RepWgt75    758     767    numeric      "Self Resp Replicate Weight #75"
RepWgt76    768     777    numeric      "Self Resp Replicate Weight #76"
RepWgt77    778     787    numeric      "Self Resp Replicate Weight #77"
RepWgt78    788     797    numeric      "Self Resp Replicate Weight #78"
RepWgt79    798     807    numeric      "Self Resp Replicate Weight #79"
RepWgt80    808     817    numeric      "Self Resp Replicate Weight #80"
RepWgt81    818     827    numeric      "Self Resp Replicate Weight #81"
RepWgt82    828     837    numeric      "Self Resp Replicate Weight #82"
RepWgt83    838     847    numeric      "Self Resp Replicate Weight #83"
RepWgt84    848     857    numeric      "Self Resp Replicate Weight #84"
RepWgt85    858     867    numeric      "Self Resp Replicate Weight #85"
RepWgt86    868     877    numeric      "Self Resp Replicate Weight #86"
RepWgt87    878     887    numeric      "Self Resp Replicate Weight #87"
RepWgt88    888     897    numeric      "Self Resp Replicate Weight #88"
RepWgt89    898     907    numeric      "Self Resp Replicate Weight #89"
RepWgt90    908     917    numeric      "Self Resp Replicate Weight #90"
RepWgt91    918     927    numeric      "Self Resp Replicate Weight #91"
RepWgt92    928     937    numeric      "Self Resp Replicate Weight #92"
RepWgt93    938     947    numeric      "Self Resp Replicate Weight #93"
RepWgt94    948     957    numeric      "Self Resp Replicate Weight #94"
RepWgt95    958     967    numeric      "Self Resp Replicate Weight #95"
RepWgt96    968     977    numeric      "Self Resp Replicate Weight #96"
RepWgt97    978     987    numeric      "Self Resp Replicate Weight #97"
RepWgt98    988     997    numeric      "Self Resp Replicate Weight #98"
RepWgt99    998    1007    numeric      "Self Resp Replicate Weight #99"
RepWgt100  1008    1017    numeric      "Self Resp Replicate Weight #100"
RepWgt101  1018    1027    numeric      "Self Resp Replicate Weight #101"
RepWgt102  1028    1037    numeric      "Self Resp Replicate Weight #102"
RepWgt103  1038    1047    numeric      "Self Resp Replicate Weight #103"
RepWgt104  1048    1057    numeric      "Self Resp Replicate Weight #104"
RepWgt105  1058    1067    numeric      "Self Resp Replicate Weight #105"
RepWgt106  1068    1077    numeric      "Self Resp Replicate Weight #106"
RepWgt107  1078    1087    numeric      "Self Resp Replicate Weight #107"
RepWgt108  1088    1097    numeric      "Self Resp Replicate Weight #108"
RepWgt109  1098    1107    numeric      "Self Resp Replicate Weight #109"
RepWgt110  1108    1117    numeric      "Self Resp Replicate Weight #110"
RepWgt111  1118    1127    numeric      "Self Resp Replicate Weight #111"
RepWgt112  1128    1137    numeric      "Self Resp Replicate Weight #112"
RepWgt113  1138    1147    numeric      "Self Resp Replicate Weight #113"
RepWgt114  1148    1157    numeric      "Self Resp Replicate Weight #114"
RepWgt115  1158    1167    numeric      "Self Resp Replicate Weight #115"
RepWgt116  1168    1177    numeric      "Self Resp Replicate Weight #116"
RepWgt117  1178    1187    numeric      "Self Resp Replicate Weight #117"
RepWgt118  1188    1197    numeric      "Self Resp Replicate Weight #118"
RepWgt119  1198    1207    numeric      "Self Resp Replicate Weight #119"
RepWgt120  1208    1217    numeric      "Self Resp Replicate Weight #120"
RepWgt121  1218    1227    numeric      "Self Resp Replicate Weight #121"
RepWgt122  1228    1237    numeric      "Self Resp Replicate Weight #122"
RepWgt123  1238    1247    numeric      "Self Resp Replicate Weight #123"
RepWgt124  1248    1257    numeric      "Self Resp Replicate Weight #124"
RepWgt125  1258    1267    numeric      "Self Resp Replicate Weight #125"
RepWgt126  1268    1277    numeric      "Self Resp Replicate Weight #126"
RepWgt127  1278    1287    numeric      "Self Resp Replicate Weight #127"
RepWgt128  1288    1297    numeric      "Self Resp Replicate Weight #128"
RepWgt129  1298    1307    numeric      "Self Resp Replicate Weight #129"
RepWgt130  1308    1317    numeric      "Self Resp Replicate Weight #130"
RepWgt131  1318    1327    numeric      "Self Resp Replicate Weight #131"
RepWgt132  1328    1337    numeric      "Self Resp Replicate Weight #132"
RepWgt133  1338    1347    numeric      "Self Resp Replicate Weight #133"
RepWgt134  1348    1357    numeric      "Self Resp Replicate Weight #134"
RepWgt135  1358    1367    numeric      "Self Resp Replicate Weight #135"
RepWgt136  1368    1377    numeric      "Self Resp Replicate Weight #136"
RepWgt137  1378    1387    numeric      "Self Resp Replicate Weight #137"
RepWgt138  1388    1397    numeric      "Self Resp Replicate Weight #138"
RepWgt139  1398    1407    numeric      "Self Resp Replicate Weight #139"
RepWgt140  1408    1417    numeric      "Self Resp Replicate Weight #140"
RepWgt141  1418    1427    numeric      "Self Resp Replicate Weight #141"
RepWgt142  1428    1437    numeric      "Self Resp Replicate Weight #142"
RepWgt143  1438    1447    numeric      "Self Resp Replicate Weight #143"
RepWgt144  1448    1457    numeric      "Self Resp Replicate Weight #144"
RepWgt145  1458    1467    numeric      "Self Resp Replicate Weight #145"
RepWgt146  1468    1477    numeric      "Self Resp Replicate Weight #146"
RepWgt147  1478    1487    numeric      "Self Resp Replicate Weight #147"
RepWgt148  1488    1497    numeric      "Self Resp Replicate Weight #148"
RepWgt149  1498    1507    numeric      "Self Resp Replicate Weight #149"
RepWgt150  1508    1517    numeric      "Self Resp Replicate Weight #150"
RepWgt151  1518    1527    numeric      "Self Resp Replicate Weight #151"
RepWgt152  1528    1537    numeric      "Self Resp Replicate Weight #152"
RepWgt153  1538    1547    numeric      "Self Resp Replicate Weight #153"
RepWgt154  1548    1557    numeric      "Self Resp Replicate Weight #154"
RepWgt155  1558    1567    numeric      "Self Resp Replicate Weight #155"
RepWgt156  1568    1577    numeric      "Self Resp Replicate Weight #156"
RepWgt157  1578    1587    numeric      "Self Resp Replicate Weight #157"
RepWgt158  1588    1597    numeric      "Self Resp Replicate Weight #158"
RepWgt159  1598    1607    numeric      "Self Resp Replicate Weight #159"
RepWgt160  1608    1617    numeric      "Self Resp Replicate Weight #160"'

##################################################################################
# Location of CPS July 2018 replicate weight file
##################################################################################

rep_wgts_jul18 <- "../../../../TUS 2018-2019 data/jul18srrep.dat"


tmp_file <- tempfile()
writeLines(data_diccionary, tmp_file)
data_diccionary_table <- read.table(tmp_file,sep="", col.names = c("variable", "initial_position","final_position", "type", "label"))

### Set varaible type  numeric to "n" 
levels(data_diccionary_table$type)<-c("n")
data_diccionary_tabletype <- as.character(data_diccionary_table$type)

### Create list for varaible name and type 
names(data_diccionary_tabletype) <-  data_diccionary_table$variable
data_diccionary_tabletype <- as.list(data_diccionary_tabletype)


##################################################################################
## Reading rep_wgts_jul18 file
##

REPS_W_CPSJUL18 <- as.data.frame(read_fwf(rep_wgts_jul18, 
 col_positions = fwf_positions( data_diccionary_table$initial_position, 
                 data_diccionary_table$final_position,
                  col_names= data_diccionary_table$variable),
                 col_types = data_diccionary_tabletype  )) 

##################################################################################
## Attaching labels
##################################################################################
for (i in 1:length(data_diccionary_table$variable))
{
  attr(REPS_W_CPSJUL18[,i],"label") <- data_diccionary_table$label[i]
}

##################################################################################
##################################################################################
### Recoding weights to 4 decimals
###
REPS_W_CPSJUL18[,c(paste0("RepWgt",0:160))]<- REPS_W_CPSJUL18[,c(paste0("RepWgt",0:160))]/10000

##################################################################################
## Saving data as a RDS File
##################################################################################


str(REPS_W_CPSJUL18, list.len=ncol(REPS_W_CPSJUL18))

saveRDS(REPS_W_CPSJUL18, file = "../data/REPS_W_CPSJUL18.RDS")

